VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cStreamCopy"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
Private Const MODULE_NAME = APPLICATION + "cStreamCopy"
Public Event ProgressChange(ByVal Min As Currency, ByVal Max As Currency, ByVal Current As Currency, ByRef Cancel As Boolean)
Public Event Done()
Public Event UserCanceled()
Private m_strSource As String
Private m_strDest As String
Private m_lngSourceOffset As Currency
Private m_lngSourceSize As Currency
Private m_bCanceled As Boolean
Private Const STD_CHUNKSIZE As Long = 65536
Public Property Get Canceled() As Boolean
    Canceled = m_bCanceled
End Property
Public Property Get SourceFile() As String
    SourceFile = m_strSource
End Property
Public Property Let SourceFile(ByVal strFile As String)
    m_strSource = strFile
End Property
Public Property Get DestinationFile() As String
    DestinationFile = m_strDest
End Property
Public Property Let DestinationFile(ByVal strFile As String)
    m_strDest = strFile
End Property
Public Property Get SourceOffset() As Currency
    SourceOffset = m_lngSourceOffset
End Property
Public Property Let SourceOffset(ByVal lngOffset As Currency)
    m_lngSourceOffset = lngOffset
End Property
Public Property Get SourceSize() As Currency
    SourceSize = m_lngSourceSize
End Property
Public Property Let SourceSize(ByVal lngSize As Currency)
    m_lngSourceSize = lngSize
End Property

Public Function Copy() As Boolean
Const PROCEDURE = MODULE_NAME + "::Copy()"
Dim objReader As cStreamReader
Dim objDest As IStream
Dim objStat As STATSTG
Dim cyBytesRead As Currency, cyBytesRemaining As Currency
Dim lngChunkSize As Long
'Dim arrBytes() As Byte
Dim blnUserAborted As Boolean
Dim strError As String

On Error GoTo ErrHandler
    lngChunkSize = STD_CHUNKSIZE
    
    Set objReader = New cStreamReader
    objReader.CreateOnFile (m_strSource)
    
    'Apply a couple defaults in case of missing info
    If m_lngSourceSize = 0 Then
        'Assume to the end of the file
        m_lngSourceSize = objReader.TotalSize - m_lngSourceOffset
    End If
    
    Set objDest = SHCreateStreamOnFile(m_strDest, STGM_CREATE Or STGM_DIRECT Or STGM_WRITE Or STGM_SHARE_EXCLUSIVE)
    'allocate enough space for write ops
    objDest.SetSize m_lngSourceSize / 10000
    
    objReader.SeekPos m_lngSourceOffset, STREAM_SEEK_SET
    cyBytesRemaining = m_lngSourceSize 'initialize
    'ReDim arrBytes(0 To lngChunkSize - 1)
    Do While cyBytesRemaining > 0
        If cyBytesRemaining < lngChunkSize Then
            'last piece of the file will probably be
            'less. So, shrink the array
            lngChunkSize = cyBytesRemaining
'            ReDim arrBytes(0 To lngChunkSize - 1)
        End If
        'Here's the transfer. We could have copied
        'directly from one stream to the other, but we may
        'need to massage the data in between. For example,
        'here's where we would decrypt the data if it was
        'encrypted.
'        objReader.Read arrBytes(0), lngChunkSize 'suck it in...
'        'Any manipulation would go here...
'        objDest.Write arrBytes(0), lngChunkSize  'and pump it out
        objReader.CopyToStream objDest, lngChunkSize 'faster just to pump it through
        cyBytesRead = cyBytesRead + lngChunkSize
        cyBytesRemaining = cyBytesRemaining - lngChunkSize
        RaiseEvent ProgressChange(0, m_lngSourceSize, cyBytesRead, blnUserAborted)
        If blnUserAborted Then
            RaiseEvent UserCanceled
            Exit Do
        End If
    Loop
    If cyBytesRemaining = 0 Then 'did we finish?
        Copy = True
        RaiseEvent Done
    Else
    End If
Done:
    On Error Resume Next
    Set objReader = Nothing 'this releases all streams
    Set objDest = Nothing   'at which point the file can be accessed.
    'Close #hFileDst: hFileDst = 0
    'Close #hFileSrc: hFileSrc = 0
    If blnUserAborted Then 'were we interrupted?
        If cyBytesRead > 0 Then
            'prompt to kill it.
            If MsgBox("Delete incomplete destination file" & vbCrLf & m_strDest & " ?", vbYesNo) = vbYes Then
                On Error Resume Next
                Err.Clear
                Kill m_strDest
                If Err.Number <> 0 Then
                    'file read-only?
                    MsgBox FormatVBError(Err.Number, Err.Description, Err.Source), vbOKOnly, "Failed to delete target file!", , PROCEDURE
                End If
            End If
        End If
    End If
    Exit Function

ErrHandler:
    Select Case MsgBox(Err.Number & ": " & Err.Description, vbAbortRetryIgnore, "Error extracting file")
    Case vbAbort:
        blnUserAborted = True
        Copy = False
        Resume Done
    Case vbRetry: Resume
    Case vbIgnore: Resume Next
    End Select
End Function

        
