VERSION 5.00
Begin VB.Form frmMain 
   Caption         =   "UnZixWin Extractor"
   ClientHeight    =   5550
   ClientLeft      =   165
   ClientTop       =   735
   ClientWidth     =   7755
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   370
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   517
   StartUpPosition =   3  'Windows Default
   Begin VB.ListBox lstContents 
      Height          =   3960
      Left            =   15
      TabIndex        =   1
      Top             =   285
      Width           =   7710
   End
   Begin VB.Label lblContents 
      BackColor       =   &H8000000C&
      Caption         =   "Open a ZIX archive to fill this list"
      ForeColor       =   &H8000000E&
      Height          =   255
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   7710
   End
   Begin VB.Label lblStatus 
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Status"
      Height          =   255
      Left            =   0
      TabIndex        =   2
      Top             =   5265
      Width           =   7680
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileOpen 
         Caption         =   "&Open Archive..."
         Shortcut        =   ^O
      End
      Begin VB.Menu mnuFileSave 
         Caption         =   "&Save As..."
         Enabled         =   0   'False
         Shortcut        =   ^S
         Visible         =   0   'False
      End
      Begin VB.Menu zzSep1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuTools 
      Caption         =   "&Tools"
      Begin VB.Menu mnuOptions 
         Caption         =   "&Options"
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuHelpAbout 
         Caption         =   "&About UnZixWin..."
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Private Enum FTEnum
    ftZix = 0
    ftTorrent = 1
End Enum

Const COLOR_ACUTE = &H2020CC
Const COLOR_WARNING = &HCCCCFF
Const COLOR_STANDARD = vbButtonFace

Private Type ZIXHEADER
    Signature As String * 3
    ManifestOffset As Currency
End Type

Private m_strSourcePath As String 'where Zix file(s) are
Private m_strDestPath As String   'where to extract the info
Private m_strFileName As String
Private m_blnAllowSave As Boolean
Private m_blnRemember As Boolean
Private m_lngLastFilterIndex As Long
Private WithEvents oCDLSave As cCommonDialog
Attribute oCDLSave.VB_VarHelpID = -1
Private WithEvents oCDLOpen As cCommonDialog
Attribute oCDLOpen.VB_VarHelpID = -1
Private WithEvents oBFC As cStreamCopy
Attribute oBFC.VB_VarHelpID = -1
Private m_CurFileType As FTEnum
Private m_Files As Collection
Private Function fCheckAvi(ByVal strFileName As String, objFile As cFileEntry) As Boolean
'This function checks the beginning of an AVI file for the RIFF AVI header.
'If it's not there, it's either crippled, encrypted or garbage, so we can warn the user.
    Dim objReader As cStreamReader
    Dim strHeader As String
    Set objReader = New cStreamReader
    objReader.CreateOnFile (strFileName)
    objReader.SeekPos objFile.Start, STREAM_SEEK_SET
    strHeader = objReader.ReadCharsA(4)
    If strHeader <> "RIFF" Then
        fCheckAvi = False
        Exit Function
    End If
    objReader.ReadLong
    strHeader = objReader.ReadCharsA(4)
    If strHeader <> "AVI " Then
        fCheckAvi = False
        Exit Function
    End If
    fCheckAvi = True
End Function
Private Sub fStreamTest()
    Dim objReader As cStreamReader
    Dim strHeader As String
    Dim lngOffsetLow As Long
    Dim lngOffsetHi As Long
    Dim currOffset As Currency
    
    On Error GoTo ErrHandler
    Set objReader = New cStreamReader
    
    objReader.CreateOnFile (m_strFileName)
    strHeader = objReader.ReadCharsA(3)
    If strHeader = "ZIX" Then
        objReader.Push
        lngOffsetLow = objReader.ReadLong
        lngOffsetHi = objReader.ReadLong
        objReader.Pop
        currOffset = objReader.ReadLongLong
        'currOffset = currOffset * 10000
        objReader.SeekPos currOffset, STREAM_SEEK_SET
        strHeader = objReader.ReadCharsA(20)
        
        
    End If
    Set objReader = Nothing
    
Done:
    Exit Sub
    
ErrHandler:
    Select Case MsgBox(FormatVBError(Err.Number, Err.Description, Err.Source), vbAbortRetryIgnore)
        Case vbAbort: Resume Done
        Case vbRetry: Resume
        Case vbIgnore: Resume Next
    End Select
    
End Sub
Private Sub ReadOptions()
    On Error Resume Next
    m_strDestPath = GetSetting(App.Title, "Paths", "DestPath", App.Path)
    If Not PathExists(m_strDestPath) Then
        'folder or medium removed. Use defaults
        m_strDestPath = App.Path
    End If
    m_strSourcePath = GetSetting(App.Title, "Paths", "SourcePath", App.Path)
    If Not PathExists(m_strSourcePath) Then
        'folder or medium removed. Use defaults
        m_strSourcePath = App.Path
    End If
    m_blnAllowSave = GetSetting(App.Title, "Options", "AllowSave", False)
    m_blnRemember = GetSetting(App.Title, "Options", "Remember", True)
    m_lngLastFilterIndex = GetSetting(App.Title, "Options", "LastFilterIndex", 1)
    
    
End Sub
Private Sub SaveOptions()
    On Error Resume Next
    If m_blnAllowSave Then
        SaveSetting App.Title, "Paths", "DestPath", m_strDestPath
        SaveSetting App.Title, "Paths", "SourcePath", m_strSourcePath
        SaveSetting App.Title, "Options", "AllowSave", True
        SaveSetting App.Title, "Options", "Remember", m_blnRemember
        SaveSetting App.Title, "Options", "LastFilterIndex", m_lngLastFilterIndex
    Else
        'delete what we can. One key for the app title
        'will remain under HKCU\Software\VB and VBA Program Settings
        DeleteSetting App.Title, "Paths"
        DeleteSetting App.Title, "Options"
    End If
End Sub


Private Sub ProcessFile()
    Dim strExt As String
'first off, let's clear out any previous data
    Set m_Files = Nothing
    m_blnAllowSave = False
    lstContents.Clear
    lblContents.Caption = ""
    If m_strFileName = "" Then Exit Sub
    strExt = Extension(m_strFileName)
    Select Case strExt
        Case "zix"
            'zix archives need a bit of probing
            'to get to the file information
            m_CurFileType = ftZix
            If ProbeZix(m_strFileName) Then
                m_blnAllowSave = True
                ListContents (True)
            End If
        Case "torrent"
            m_CurFileType = ftTorrent
            If ProbeTorrent(m_strFileName) Then
                m_blnAllowSave = False
                ListContents (False)
            End If
        Case Else
            m_blnAllowSave = False
            lblStatus.Caption = "Unknown file type."
    End Select
mnuFileSave.Visible = m_blnAllowSave

End Sub
Private Sub SetupTabs()
Dim objFile As cFileEntry
Dim lngMaxLen As Long
Dim arrTabs() As Long
If m_Files Is Nothing Then Exit Sub
If m_Files.Count = 0 Then Exit Sub
'Measure the longest file name
For Each objFile In m_Files
    If Len(objFile.Name) > lngMaxLen Then
        lngMaxLen = Len(objFile.Name)
    End If
Next
ReDim arrTabs(0 To 1)
arrTabs(0) = (lngMaxLen + 3) * 4
SendMessage lstContents.hWnd, LB_SETTABSTOPS, 1, arrTabs(0)

End Sub
Private Sub ListContents(Optional ByVal blnCanExtract As Boolean)
    lstContents.Clear
    Dim objFile As cFileEntry
    Dim I As Long
    If Not (m_Files Is Nothing) Then
        If m_Files.Count Then
            Call SetupTabs
            For I = 1 To m_Files.Count
                Set objFile = m_Files(I)
                lstContents.AddItem objFile.Name & vbTab & " (" & objFile.Size & " bytes)"
                lstContents.ItemData(lstContents.NewIndex) = I
            Next
            If blnCanExtract Then
                lblContents.Caption = "Select &Contents to extract:"
            Else
                lblContents.Caption = "Thes files are not extractable."
            End If
        End If
        lblStatus.Caption = m_Files.Count & " files(s)"
    End If
End Sub
Private Sub ResizeControls()
    Dim lngTop As Long, lngLeft As Long
    Dim lngWidth As Long, lngWindowWidth As Long
    Dim lngHeight As Long, lngWindowHeight As Long
    lngWindowWidth = Me.ScaleWidth
    lngWindowHeight = Me.ScaleHeight
    'Resize and reposition the legend label
    lngTop = 0: lngHeight = Me.lblContents.Height
    lngWidth = lngWindowWidth: lngHeight = lblContents.Height
    lblContents.Move lngLeft, lngTop, lngWidth, lngHeight
    lngTop = lngWindowHeight - 20: lngLeft = 0: lngWidth = lngWindowWidth: lngHeight = 20
    'Resize and reposition status label
    lblStatus.Move lngLeft, lngTop, lngWidth, lngHeight
    'Slap lstContents into place
    lngTop = lblContents.Top + lblContents.Height
    lngHeight = (lngWindowHeight - lngTop) - lblStatus.Height
    lstContents.Move lngLeft, lngTop, lngWidth, lngHeight
End Sub
Private Function ProbeTorrent(ByVal strPath As String) As Boolean
    Dim objReader As cStreamReader
    Dim objManifest As cManifest
    Dim strError As String
    
On Error GoTo ErrHandler
    lblStatus.Caption = "Analyzing Torrent..."
    Set objReader = New cStreamReader
    objReader.CreateOnFile (strPath)
    Set objManifest = New cManifest
    If objManifest.Parse(objReader) Then
        Set m_Files = objManifest.Files
        ProbeTorrent = True
    End If
Done:
    On Error Resume Next
    Set objReader = Nothing
    Set objManifest = Nothing
    Exit Function
    
ErrHandler:
    Select Case MsgBox(FormatVBError(Err.Number, Err.Description, Err.Source), vbAbortRetryIgnore, "Error Parsing Torrent")
        Case vbAbort: Resume Done
        Case vbRetry: Resume
        Case vbIgnore: Resume Next
    End Select

End Function
Private Function ProbeZix(ByVal strPath As String) As Boolean
    Dim Header As ZIXHEADER
    Dim objReader As cStreamReader
    Dim objManifest As cManifest
    
    On Error GoTo ErrHandler
    
    lblStatus.Caption = "Analyzing archive..."
    Set objReader = New cStreamReader
    objReader.CreateOnFile (strPath)
    If objReader.TotalSize = 0 Then
        Err.Raise ERR_FILE_IS_EMPTY, "::ProbeZix", "The file is empty."
    End If
    Header.Signature = objReader.ReadCharsA(3)
    Header.ManifestOffset = objReader.ReadLongLong
    
    If Header.Signature = "ZIX" Then 'We've got a Zix archive
        'Seek to the manifest and probe it
        Set objManifest = New cManifest
        objReader.SeekPos Header.ManifestOffset, STREAM_SEEK_SET
        'We just sought to the end of the payload.
        'The rest of the archive is the manifest.
        If objManifest.Parse(objReader) Then
            'Successfully parsed manifest. Now we can add the
            'contents to our list box
            Set m_Files = objManifest.Files
            ProbeZix = True
        Else
            MsgBox "Failed to parse contents of archive."
        End If
    Else
        ProbeZix = False
        Err.Raise ERR_WRONG_FILE_FORMAT, "ProbeZix", "This is not a ZIX archive."
        'TODO: Throw error
    End If
    ProbeZix = True
    
Done:
    On Error Resume Next
    Set objReader = Nothing
    Set objManifest = Nothing
    Exit Function
    
ErrHandler:
    Select Case MsgBox(FormatVBError(Err.Number, Err.Description, Err.Source), vbAbortRetryIgnore, "Error Parsing Archive")
        Case vbAbort: Resume Done
        Case vbRetry: Resume
        Case vbIgnore: Resume Next
    End Select

End Function


Private Sub Form_Activate()
    Center Me
End Sub

Private Sub Form_Load()
    'Obtain any saved source and destination paths for the benefit
    'of browsing
    Call ReadOptions
    'use them for module-level work
    Me.ScaleMode = 3 'set to pixels, in case we forget
    Set oCDLOpen = New cCommonDialog
    Set oCDLSave = New cCommonDialog
End Sub

Private Sub Form_Resize()
    If Me.WindowState = vbMinimized Then
        Exit Sub
    End If
    Call ResizeControls
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Call SaveOptions
End Sub
Private Sub SetStatus(ByVal Color As OLE_COLOR, ByVal Bold As Boolean, ByVal strText As String)
    With lblStatus
        .FontBold = Bold
        .BackColor = Color
        .Caption = strText
        .ToolTipText = strText
    End With
End Sub

Private Sub lstContents_Click()
    Dim objFile As cFileEntry
    Dim idx As Long
On Error GoTo ErrHandler
    mnuFileSave.Enabled = False
    SetStatus vbButtonFace, False, ""
    If Len(lstContents.Text) Then
        'there's something there.
        'If we can extract the file, we enable the menu
        idx = lstContents.ListIndex + 1
        If Not (m_Files Is Nothing) Then
            If m_Files.Count Then
                Set objFile = m_Files(idx)
                If objFile.IsExtractable Then
                    'Display warnings about common viruses and hoaxes.
                    'Yeech! I'll write something more elegant in an upcoming
                    'release. I promise!
                    If (objFile.Name = "codec.exe") Then
                        'Infected with Downloader.Agent.KNG
                        SetStatus COLOR_ACUTE, True, "WARNING: Almost certainly infected!"
                    ElseIf (objFile.Name) = "decompress_iso.exe" Then
                        SetStatus COLOR_ACUTE, True, "WARNING: Almost certainly infected!"
                    ElseIf (Extension(objFile.Name) = "exe") Then
                        SetStatus COLOR_WARNING, True, "WARNING: Might be infected. Ectract at your own risk."
                    ElseIf (objFile.Name = "Problems viewing the .AVI.html") Then
                        'Tries to lure you to install spyware
                        SetStatus COLOR_WARNING, True, "WARNING: Distrust any information in this file!"
                    ElseIf (objFile.Name = "001.JPG" And objFile.Size = 84738) Then
                        'This, too.
                        SetStatus COLOR_WARNING, True, "WARNING: Image contains misleading instructions."
                    ElseIf Extension(objFile.Name) = "avi" Then
                        'Quick check to see if the RIFF headers are in place.
                        If (fCheckAvi(m_strFileName, objFile) = False) Then
                            SetStatus COLOR_WARNING, True, "WARNING: AVI seems to be garbled or garbage. Waste of time."
                        Else
                            SetStatus COLOR_STANDARD, False, objFile.Name & " (" & FormatBytes(objFile.Size) & ")"
                        End If
                    Else
                        SetStatus vbButtonFace, False, objFile.Name & " (" & FormatBytes(objFile.Size) & ")"
                    End If
                    'We can only warn the user about any problems or risks. Prohibiting
                    'extraction isn't very user friendly. So...
                    mnuFileSave.Enabled = True
                Else
                    lblStatus.BackColor = &HCCCCFF
                    'What's the major problem?
                    If objFile.IsCompressed Then
                        SetStatus COLOR_WARNING, True, "The file is compressed. Cannot extract."
                    Else
                        'remaining option: the file simply isn't there.
                        SetStatus COLOR_WARNING, False, "This file is virtual. Cannot extract."
                    End If
                End If 'file could be extracted
            End If 'there were any files
        End If 'we have a file collection
    End If 'the user selected anything
Done:
    Exit Sub

ErrHandler:
    Select Case MsgBox(FormatVBError(Err.Number, Err.Description, Err.Source), vbAbortRetryIgnore, "An error has occurred!")
        Case vbAbort: Resume Done
        Case vbRetry: Resume
        Case vbIgnore: Resume Next
    End Select
    
End Sub

Private Sub mnuExit_Click()
    Unload Me
End Sub

Private Sub mnuFileOpen_Click()
    
On Error GoTo ErrHandler
    'Right here is a good place to reset all the stuff from previous
    'selections
    Set m_Files = Nothing
    lstContents.Clear
    SetStatus vbButtonFace, False, ""
    m_strFileName = ""
    Me.Caption = App.Title
    
    With oCDLOpen
        .InitDir = m_strSourcePath
        .DialogTitle = "Select ZIX archive or Torrent"
        .Filter = "ZIX archives (*.ZIX)|*.zix|Torrent files (*.torrent)|*.torrent|All Files (*.*)|*.*)"
        .FilterIndex = m_lngLastFilterIndex
        .flags = OFN_FILEMUSTEXIST Or OFN_PATHMUSTEXIST
        .CancelError = True
        .ShowOpen
        m_strFileName = .Filename
    End With
    If m_blnRemember Then
        m_strSourcePath = NoFile(m_strFileName)
        m_lngLastFilterIndex = oCDLOpen.FilterIndex
    End If
    SetStatus vbButtonFace, False, m_strFileName
    
    'Kick off the parsing
    Call ProcessFile
    Me.Caption = "[ " & NoPath(m_strFileName) & " ] - " & App.Title
Done:
    Exit Sub
    
ErrHandler:
    If Err = 20001 Then
        'cancel
        SetStatus vbButtonFace, False, "Open canceled."
        Resume Done
    Else
        Select Case MsgBox(Err.Number & ": " & Err.Description, vbAbortRetryIgnore, "Error Opening File")
        Case vbAbort: Resume Done
        Case vbRetry: Resume
        Case vbIgnore: Resume Next
        End Select
    End If
    
    
End Sub

Private Sub mnuFileSave_Click()
    Dim lngIndex As Long
    Dim objFile As cFileEntry
    Dim strDestFile As String
    Dim f As frmStreamCopyProgress
    
On Error GoTo ErrHandler
    'As a first order of business, we get a hold of the cFileEntry object
    'corresponding to the selected list index (adding one to account for zero base)
    If lstContents.ListIndex < 0 Then Exit Sub
    lngIndex = lstContents.ListIndex + 1
    Set objFile = m_Files(lngIndex)
    strDestFile = objFile.Name
    'Then we politely ask the useer where to put it
DoPrompt:
    With oCDLSave
        .InitDir = m_strDestPath
        .flags = OFN_OVERWRITEPROMPT Or OFN_PATHMUSTEXIST
        .DialogTitle = "Extract and save as:"
        .CancelError = True
        .Filter = "All Files (*.*)|*.*"
        .FilterIndex = 0
        .FileTitle = strDestFile 'suggest original name
        .Filename = strDestFile
        .ShowSave
    End With
    'pick up the name the user entered or accepted
    strDestFile = oCDLSave.Filename
    'If we get here, and the destination file exists, we
    'must have had an OK to overwrite it.
    If FileExists(strDestFile) Then
        'Kill doesn't work on hidden files ('file not found error')
        'So, pre-empt this by clearing the offending attributes.
        SetAttr strDestFile, 0&
        Kill strDestFile
    End If
    If m_blnRemember Then
        m_strDestPath = NoFile(strDestFile)
    End If
    'Check to see that we have enough space
    If GetFreeSpace(m_strDestPath) < objFile.Size Then
        Err.Raise ERR_NOT_ENOUGH_SPACE, App.Title, "There is not enough space left on the target drive."
    End If
    SetStatus vbButtonFace, False, "Extracting file... Please wait."
    'Instantiate a handy object to do the extraction and
    'raise some nice events in the process
    Set oBFC = New cStreamCopy
    With oBFC
        .SourceFile = m_strFileName
        .SourceOffset = objFile.Start
        .SourceSize = objFile.Size
        .DestinationFile = strDestFile
    End With
    'We'll use a nifty little dialog to entertain
    'the user during this potentially lengthy process
    Set f = New frmStreamCopyProgress
    f.CopyObject = oBFC
    f.Show , Me
    If oBFC.Copy = True Then
        'everything went okay.
        SetStatus vbButtonFace, False, "Extraction complete!"
    Else
        If oBFC.Canceled Then
            SetStatus &HCCCCFF, False, "Extraction aborted."
        End If
    End If
    
Done:
    On Error Resume Next
    Set objFile = Nothing
    Set oBFC = Nothing
    Unload f
    Set f = Nothing
    Exit Sub
    
ErrHandler:
    If Err.Number = 20001 Then 'dialog cancel
        SetStatus &HCCCCFF, False, "Extraction canceled."
        Resume Done
    Else
        Select Case MsgBox(Err.Number & ": " & Err.Description, vbAbortRetryIgnore, "Error Saving File")
        Case vbAbort: Resume Done
        Case vbRetry:
            If Err.Number = ERR_NOT_ENOUGH_SPACE Then
                'give the user a chance to save someplace else
                Resume DoPrompt
            Else
                'whatever went wrong, we retry it
                Resume
            End If
        Case vbIgnore: Resume Next
        End Select
    End If
End Sub

Private Sub mnuHelpAbout_Click()
    frmAbout.Show vbModal, Me
End Sub

Private Sub mnuOptions_Click()
    Dim f As frmOptions
    Set f = New frmOptions
    With f
        .AllowSave = m_blnAllowSave
        .SourcePath = m_strSourcePath
        .DestPath = m_strDestPath
        .Remember = m_blnRemember
    End With
    f.Show vbModal, Me
    If f.Response = vbOK Then
        m_strSourcePath = f.SourcePath
        m_strDestPath = f.DestPath
        m_blnAllowSave = f.AllowSave
        m_blnRemember = f.Remember
    End If
    Unload f
    Set f = Nothing
End Sub

Private Sub oBFC_Done()
    SetStatus vbButtonFace, False, "Extraction Completed."
End Sub

Private Sub oBFC_UserCanceled()
    SetStatus &HCCCCFF, False, "Extraction Aborted."
End Sub

